<?php
session_start();
if (!isset($_SESSION['login'])) {
    header("Location: login.php");
    exit;
}

include 'koneksi.php';

/* TOTAL ARTIKEL */
$qArtikel = mysqli_query($conn, "SELECT COUNT(*) AS total FROM artikel");
$dataArtikel = mysqli_fetch_assoc($qArtikel);
$totalArtikel = $dataArtikel['total'];

/* TOTAL PESAN */
$qPesan = mysqli_query($conn, "SELECT COUNT(*) AS total FROM kontak");
$dataPesan = mysqli_fetch_assoc($qPesan);
$totalPesan = $dataPesan['total'];

?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Dashboard Admin</title>
    <link rel="stylesheet" href="css/admin.css">
</head>
<body>


<!-- SIDEBAR -->
<div class="sidebar">
    <div class="sidebar-brand">
        <h2>WTC <span>ADMIN</span></h2>
    </div>
    <ul>
        <li><a class="active" href="dashboard.php"><i class="fas fa-home"></i> <span>Dashboard</span></a></li>
        <li><a href="artikel.php"><i class="fas fa-edit"></i> <span>Artikel</span></a></li>
        <li><a href="kontak.php"><i class="fas fa-envelope"></i> <span>Pesan</span></a></li>
        <li><a href="logout.php"><i class="fas fa-sign-out-alt"></i> <span>Logout</span></a></li>
    </ul>
</div>

<!-- MAIN CONTENT -->
<div class="content">

    <!-- TOPBAR -->
    <div class="topbar">
        <div>
            <h1>Dashboard</h1>
            <p>Panel Admin Website</p>
        </div>
        <div class="user">
            <i class="fas fa-user-circle"></i>
            <?= htmlspecialchars($_SESSION['username']); ?>
        </div>
    </div>

   <div class="card-wrapper">

    <div class="card blue">
        <h3>Total Artikel</h3>
        <div class="number"><?= $totalArtikel; ?></div>
    </div>

    <div class="card green">
        <h3>Pesan Masuk</h3>
        <div class="number"><?= $totalPesan; ?></div>
    </div>

    <div class="card orange">
        <h3>Status Website</h3>
        <div class="number">Online</div>
    </div>

</div>



</div>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</body>

</html>
